%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: plot_co2_spec_int_corr
%
% Scope:    plot overview CO2 concentration correction
%
% Input:    data (structure),
%           bindata (structure),
%           binref (structure),
%           list of gas names (cell),
%           index of variable 1 (CO2) used for correction (double),
%           index of variable 2 (N2O) used for correction (double),
%           index of "target" variables that are being corrected (double),
%           slope of CO2 concentration correction (double),
%           intercept of CO2 concentration correction (double),
%           axis label CO2 concentration correction (string),
%           anchor gas name (string),
%           plot title (string)
%
% Output:   overview figure CO2 concentration correction
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function plot_co2_spec_int_corr(data,bindata,binref,gasnames,bindata_idx,bindata_idx2,target_idx,slope_co2,intercept_co2,axislabel,ind_anchor,titlename)

figure;
for z=1:width(target_idx)
    
    subplot(3,2,2*z-1);
    hold on;
    for i=1:width(gasnames)
    scatter(bindata.(gasnames{1,i})(:,1),bindata.(gasnames{1,i})(:,target_idx(1,z)),10);
    end
    errorbar(binref.mean(:,1),binref.mean(:,target_idx(1,z)),binref.std(:,target_idx(1,z)),'marker','o','linestyle','none','color','k','markeredgecolor','k','markerfacecolor','none','linewidth',1.2);
    grid on;
    box on;
    xlim([0 data.all(end,1)-bindata.start_time]);
    xlabel('Time [h]','fontsize',12);
    ylabel({sprintf('%s',bindata.varlabels{1,target_idx(1,z)})},'fontsize',12);
    if z==1
        lll=cell(1,width(gasnames));
        for n=1:width(gasnames)
            lll{n} = string(gasnames{1,n}); end
        legend(lll,'location','northeast');
        title({sprintf('%s',titlename)});
    end
   
    subplot(3,2,2*z);    
    hold on;
    for i=1:width(gasnames)
    scatter(bindata.(gasnames{1,i})(:,bindata_idx2)./bindata.(gasnames{1,i})(:,bindata_idx),bindata.(gasnames{1,i})(:,target_idx(1,z)),'handlevisibility','off');
    end
    plot([min(bindata.all(:,bindata_idx2)./bindata.all(:,bindata_idx)) max(bindata.all(:,bindata_idx2)./bindata.all(:,bindata_idx))],slope_co2(1,z)*[min(bindata.all(:,bindata_idx2)./bindata.all(:,bindata_idx)) max(bindata.all(:,bindata_idx2)./bindata.all(:,bindata_idx))]+intercept_co2(1,z),'-g');
    yline(binref.(gasnames{1,ind_anchor})(1,target_idx(1,z)),'--k');
    xline(binref.(gasnames{1,ind_anchor})(1,bindata_idx2)./binref.(gasnames{1,ind_anchor})(1,bindata_idx),'--k');
    grid on;
    box on;
    xlabel({sprintf('%s',axislabel{1,1})},'fontsize',12);
    ylabel({sprintf('%s',bindata.varlabels{1,target_idx(1,z)})},'fontsize',12);
    legend('given slope','fontsize',10);
 
end

    x0 = 10;
    y0 = 50;
    ww = 900;
    hh = 700;
    set(gcf,'units','points','position',[x0,y0,ww,hh]);
    set(gcf,'Units','Inches');
    pos = get(gcf,'Position');
    set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3),pos(4)]);

%print(gcf,'C:\Users\brsi\Desktop\temp9_corr_before_n2o','-dpng', '-r800');

end

